/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.ReadException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.DeviceModelElementType;
import com.quantumdata.sct.dao.jaxb.DeviceModels;
import com.quantumdata.sct.dao.jaxb.DeviceModelsType;
import com.quantumdata.sct.dao.vo.DeviceModelVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.util.ArrayList;
import java.util.Iterator;

public final class DeviceModelDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    private DeviceModelsType.DeviceModelElement get(Integer n) throws ReadException {
        if (n == null) {
            throw new ReadException("Invalid index");
        }
        int n2 = ((DeviceModels)this.daoObject).getDeviceModelsCollection().size();
        if (n >= n2) {
            throw new ReadException("Index out of bounds error");
        }
        DeviceModelsType.DeviceModelElement deviceModelElement = (DeviceModelsType.DeviceModelElement)((DeviceModels)this.daoObject).getDeviceModelsCollection().get(n);
        return deviceModelElement;
    }

    public void readCallback() throws DAOException {
        try {
            DeviceModels deviceModels = (DeviceModels)this.daoObject;
            int n = deviceModels.getDeviceModelsCollection().size();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                DeviceModelsType.DeviceModelElement deviceModelElement = (DeviceModelsType.DeviceModelElement)deviceModels.getDeviceModelsCollection().get(i);
                this.daoCollection.put(deviceModelElement.getDeviceId(), new Integer(i));
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public final Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public final IPersistable getValueObjectForKey(Object object) throws CreateException {
        IPersistable iPersistable = null;
        try {
            if (!this.daoCollection.containsKey(object)) {
                throw new Exception("Element with key = " + object + " not found");
            }
            Integer n = (Integer)this.daoCollection.get(object);
            DeviceModelsType.DeviceModelElement deviceModelElement = this.get(n);
            iPersistable = this.createPersistable(deviceModelElement);
        }
        catch (Exception exception) {
            throw new CreateException(exception.getMessage());
        }
        return iPersistable;
    }

    public final IPersistable[] findByAll() throws Exception {
        int n = ((DeviceModels)this.daoObject).getDeviceModelsCollection().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            DeviceModelsType.DeviceModelElement deviceModelElement = (DeviceModelsType.DeviceModelElement)((DeviceModels)this.daoObject).getDeviceModelsCollection().get(i);
            iPersistableArray[i] = this.createPersistable(deviceModelElement);
        }
        return iPersistableArray;
    }

    public final Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof DeviceModelsType.DeviceModelElement) {
            DeviceModelsType.DeviceModelElement deviceModelElement = (DeviceModelsType.DeviceModelElement)object;
            object2 = deviceModelElement.getDeviceId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    private IPersistable createPersistable(Object object) throws Exception {
        DeviceModelVO deviceModelVO = new DeviceModelVO();
        if (object instanceof DeviceModelsType.DeviceModelElement) {
            this.copyFrom((DeviceModelsType.DeviceModelElement)object, deviceModelVO);
        }
        return deviceModelVO;
    }

    private void copyFrom(DeviceModelsType.DeviceModelElement deviceModelElement, DeviceModelVO deviceModelVO) throws Exception {
        deviceModelVO.setId(deviceModelElement.getDeviceId());
        deviceModelVO.setLastUpdate(deviceModelElement.getLastUpdate());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DeviceModelElementType.ModelId modelId : deviceModelElement.getModels()) {
            arrayList.add(modelId.getValue());
        }
        deviceModelVO.setModels(arrayList);
    }

    private void copyTo(DeviceModelsType.DeviceModelElement deviceModelElement, DeviceModelVO deviceModelVO) throws Exception {
        deviceModelElement.setDeviceId((String)deviceModelVO.getId());
        deviceModelElement.setLastUpdate(deviceModelVO.getLastUpdate());
        Iterator iterator = deviceModelVO.getModels().iterator();
        while (iterator.hasNext()) {
            DeviceModelElementType.ModelId modelId = this.factory.createDeviceModelElementTypeModelId();
            String string = (String)iterator.next();
            modelId.setValue(string);
            deviceModelElement.getModels().add(modelId);
        }
    }

    protected final void updateObject(IPersistable iPersistable) throws Exception {
        if (iPersistable instanceof DeviceModelVO) {
            DeviceModelVO deviceModelVO = (DeviceModelVO)iPersistable;
            Integer n = (Integer)this.daoCollection.get(deviceModelVO.getId());
            DeviceModelsType.DeviceModelElement deviceModelElement = this.get(n);
            deviceModelElement.getModels().clear();
            this.copyTo(deviceModelElement, deviceModelVO);
        }
    }

    protected final IPersistable findByPrimaryKey(String string) {
        DeviceModelVO deviceModelVO = null;
        try {
            if (this.daoCollection.containsKey(string)) {
                Integer n = (Integer)this.daoCollection.get(string);
                DeviceModelsType.DeviceModelElement deviceModelElement = this.get(n);
                deviceModelVO = new DeviceModelVO();
                this.copyFrom(deviceModelElement, deviceModelVO);
            }
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            deviceModelVO = null;
        }
        return deviceModelVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                Integer n = (Integer)this.daoCollection.get(object);
                ((DeviceModels)this.daoObject).getDeviceModelsCollection().remove(n);
            }
            this.flush();
            this.readCallback();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public final void add(IPersistable iPersistable) throws CreateException {
        this.add(iPersistable, 0);
    }

    public final void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            if (iPersistable instanceof DeviceModelVO) {
                DeviceModelsType.DeviceModelElement deviceModelElement = (DeviceModelsType.DeviceModelElement)this.factory.createDeviceModelElementType();
                this.copyTo(deviceModelElement, (DeviceModelVO)iPersistable);
                if (n > 0) {
                    ((DeviceModels)this.daoObject).getDeviceModelsCollection().add(n, iPersistable);
                } else {
                    ((DeviceModels)this.daoObject).getDeviceModelsCollection().add(iPersistable);
                }
            } else {
                throw new Exception("Invalid Value Object being passed");
            }
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

